package team.frc.morpheus.chargedup.subsystems;

import com.ctre.phoenix.motorcontrol.ControlMode;
import com.ctre.phoenix.motorcontrol.NeutralMode;
import com.ctre.phoenix.motorcontrol.SupplyCurrentLimitConfiguration;
import com.ctre.phoenix.motorcontrol.TalonFXControlMode;
import com.ctre.phoenix.motorcontrol.can.TalonFX;
import com.ctre.phoenix.motorcontrol.can.TalonSRX;
import com.ctre.phoenix.motorcontrol.TalonSRXControlMode;
import com.ctre.phoenix.motorcontrol.TalonSRXFeedbackDevice;

import edu.wpi.first.math.geometry.Rotation3d;
import edu.wpi.first.math.geometry.Translation3d;
import edu.wpi.first.wpilibj.AnalogInput;
import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;
import edu.wpi.first.wpilibj2.command.SubsystemBase;

import java.util.Optional;

import static team.frc.morpheus.chargedup.Constants.Wrist.*;
import static team.frc.morpheus.chargedup.Constants.Nado.*;

public class Nado extends SubsystemBase{
    private final TalonSRX wristDeployer;
    private final TalonFX spin;

    private static Optional<Nado> instance = Optional.empty();

    private Nado() {
        instance = Optional.of(this);
        wristDeployer = new TalonSRX(WRIST);
        wristDeployer.configFactoryDefault();
        wristDeployer.setNeutralMode(NeutralMode.Brake);

        wristDeployer.setInverted(false);
        wristDeployer.setSensorPhase(true);

        wristDeployer.configSelectedFeedbackSensor(
            TalonSRXFeedbackDevice.CTRE_MagEncoder_Absolute, 1, 40);

        wristDeployer.configSelectedFeedbackSensor(
            TalonSRXFeedbackDevice.CTRE_MagEncoder_Relative, 0, 40);

        // wristDeployer.setSelectedSensorPosition(
        //     wristDeployer.getSelectedSensorPosition(1) - absoluteOrigin ,0,0);

        wristDeployer.config_kF(0, MAGIC_KF);
        wristDeployer.config_kP(0, MAGIC_KP);

        wristDeployer.configPeakOutputForward(1.0);
        wristDeployer.configPeakOutputReverse(-1.0);
        wristDeployer.configNominalOutputForward(0.0);
        wristDeployer.configNominalOutputReverse(0.0);

        wristDeployer.configForwardSoftLimitThreshold(ENCODER_MAX_TICKS);
        wristDeployer.configReverseSoftLimitThreshold(ENCODER_MIN_TICKS);
        wristDeployer.configForwardSoftLimitEnable(true);
        wristDeployer.configReverseSoftLimitEnable(true);

        wristDeployer.configMotionCruiseVelocity(MAGIC_CRUISE_VELOCITY);
        wristDeployer.configMotionAcceleration(MAGIC_ACCELERATION);

        spin = new TalonFX(SPIN);
        spin.configFactoryDefault();
        spin.setNeutralMode(NeutralMode.Coast);
        spin.setInverted(false);
        spin.configSupplyCurrentLimit(new SupplyCurrentLimitConfiguration(true, 20, 10, 200));
    }

    public static synchronized Nado getInstance() {
        return instance.orElseGet(Nado::new);
    }
    //Wrist
    //#region
    public double getWristCurrent() {
        return wristDeployer.getStatorCurrent();
    }

    // sets the wrist deployment to the angle specified in the argument
    public void setWristDeploy(double angle)
    {
        wristDeployer.set(TalonSRXControlMode.MotionMagic, degreesToEncoder(angle));
    }

    public void setWristManual(double v) {
        wristDeployer.set(TalonSRXControlMode.PercentOutput, v);
    }

    public double getWristAngle() {
        return encoderToDegrees(wristDeployer.getSelectedSensorPosition(0));
    }

    //converts degrees to encoder ticks
    private static double degreesToEncoder(double degrees)
    {
        return ENCODER_TICKS_PER_DEGREE * degrees;
    }

    //converts encoder ticks to degrees
    private static double encoderToDegrees(double encoder)
    {
        return encoder / ENCODER_TICKS_PER_DEGREE;
    }
    //#endregion
    
    //Nado

    public void setSpin(double velocity){
        spin.set(TalonFXControlMode.Velocity, velocity);
    }

    public void setSpinManual(double v) {
        spin.set(ControlMode.PercentOutput, v);
    }

    public double getSpinCurrent() {
        return spin.getStatorCurrent();
    }

    @Override
    public void periodic()
    {
        SmartDashboard.putNumber("Wrist Angle", getWristAngle());
        SmartDashboard.putNumber("Wrist Current", getWristCurrent());
    }
}
