package team.frc.morpheus.chargedup.commands.nado;

import edu.wpi.first.wpilibj2.command.Command;
import team.frc.morpheus.chargedup.subsystems.Nado;

public class NadoWristAngle extends Command {
    private final Nado nado;
    private final double targetAngle, tolerance;

    public NadoWristAngle(double targetAngle, double tolerance) {
        nado = Nado.getInstance();
        this.targetAngle = targetAngle;
        this.tolerance = tolerance;

        addRequirements(nado);
    }

    @Override
    public void execute() {
        nado.setWristDeploy(targetAngle);
    }

    @Override
    public boolean isFinished() {
        return Math.abs(nado.getWristAngle() - targetAngle) < tolerance;
    }

    @Override
    public void end(boolean interrupted) {
        if (interrupted) nado.setWristManual(0.0);
    }
}
