package team.frc.morpheus.chargedup.commands.nado;

public enum NadoState {
        INTAKE(110, 0.3, 10),
        STOW(0, 0.07, 3),
        SHOOT_HIGH(20, -0.62, 3),
        SHOOT_MID(20, -0.4, 3),
        SHOOT_LOW_FAR(40, -1.0, 3),
        SHOOT_LOW(40, -0.15, 10);

        public final double wristAngle;
        public final double wristTolerance;
        public final double spin;

        private NadoState(double wristAngle, double spin, double tolerance) {
            this.wristAngle = wristAngle;
            this.spin = spin;
            this.wristTolerance = tolerance;
        }
    }
