package team.frc.morpheus.chargedup.commands.nado;

import edu.wpi.first.wpilibj.Timer;
import edu.wpi.first.wpilibj2.command.Command;
import team.frc.morpheus.chargedup.Constants;
import team.frc.morpheus.chargedup.subsystems.Nado;

public class NadoSpinSet extends Command {
    private final Nado nado;
    private final double spin;
    private final boolean enableLimiter;
    private double initime;

    public NadoSpinSet(double spin, boolean enableLimiter){
        this.nado = Nado.getInstance();
        this.spin = spin;
        this.enableLimiter = enableLimiter;

        addRequirements(nado);
    }

    @Override
    public void initialize() {
        nado.setSpinManual(spin);

        initime = Timer.getFPGATimestamp();
    }

    @Override
    public boolean isFinished() {
        // Current Spike Detection
        return enableLimiter && nado.getSpinCurrent() > Constants.Nado.INTAKE_CURRENT_THRESHOLD;
    }

    @Override
    public void end(boolean interrupted){
        nado.setSpinManual(0);
    }
}
