package team.frc.morpheus.chargedup.commands.nado;

import edu.wpi.first.wpilibj2.command.Command;
import team.frc.morpheus.chargedup.subsystems.Nado;

public class NadoSet extends Command {
    
    private final NadoState state;
    private final Nado nado;
    
    public NadoSet(NadoState state) {
        nado = Nado.getInstance();
        this.state = state;

        addRequirements(nado);
    }

    @Override
    public void initialize() {
        nado.setWristDeploy(state.wristAngle);
        nado.setSpinManual(state.spin);
    }

    @Override
    public boolean isFinished() {
        return Math.abs(nado.getWristAngle() - state.wristAngle) < state.wristTolerance;
    }

    @Override
    public void end(boolean interrupted) {
        if (interrupted) {
            nado.setWristManual(0.0);
            nado.setSpinManual(0.0);
        }
    }
}
