package team.frc.morpheus.chargedup.commands.drivebase;

import edu.wpi.first.wpilibj2.command.Command;
import team.frc.morpheus.chargedup.subsystems.DriveSubsystem;

public class TurnInPlace extends Command {
    
    private double startRot;
    private final DriveSubsystem drive = DriveSubsystem.getInstance();
    private final double degrees;
    private final double speed;
    
    public TurnInPlace(double degrees, double speed) {
        this.degrees = degrees;
        this.speed = speed;

        addRequirements(drive);
    }

    @Override
    public void initialize() {
        startRot = drive.getHeading();
    }

    @Override
    public void execute() {
        drive.drive(0,0, speed, true);
    }

    @Override
    public boolean isFinished() {
        return drive.getHeading() - startRot >= degrees;
    }

    @Override
    public void end(boolean interrupted) {
        drive.drive(0,0,0,true);
    }
}
