package team.frc.morpheus.chargedup.commands.drivebase;

import edu.wpi.first.wpilibj2.command.Command;
import team.frc.morpheus.chargedup.subsystems.DriveSubsystem;

public class DriveDistance extends Command {
    
    private double startPos;
    private final double speedX;
    private final double distance;
    private final boolean posDirection;
    private final DriveSubsystem drive = DriveSubsystem.getInstance();

    public DriveDistance(double speedX, double distance, boolean posDirection){
        this.speedX = speedX;
        this.distance = distance;
        this.posDirection = posDirection;

        addRequirements(drive);
    }

    @Override
    public void initialize(){
        startPos = drive.getPose().getX();
    }

    @Override
    public void execute(){
        drive.drive(speedX, 0, 0, true);
    }

    @Override
    public boolean isFinished(){
        return drive.getPose().getX() - startPos <= distance;
    }

    @Override
    public void end(boolean interrupted){
        drive.drive(0.0, 0.0, 0.0, true);
    }
}
