package team.frc.morpheus.chargedup.commands.drivebase;

import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;
import edu.wpi.first.wpilibj2.command.Command;
import team.frc.morpheus.chargedup.subsystems.DriveSubsystem;

public class AutoBalance extends Command {
    private  final DriveSubsystem drive;
    
    public AutoBalance() {
        drive = DriveSubsystem.getInstance();

        addRequirements(drive);
    }

    @Override
    public void initialize() {

    }

    @Override
    public void execute() {
        final double error = drive.getRoll();
        SmartDashboard.putNumber("Gyro Roll", error);
        if (error > 10) drive.drive(-0.3, 0.0, 0.0, true);
        else if (error < -10) drive.drive(0.3, 0.0, 0.0, true);
        else drive.drive(0.0, 0.0, 0.0, true);
    }

    @Override
    public void end(boolean interrupted) {
        drive.drive(0.0, 0.0, 0.0, true);
    }
}
