// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package team.frc.morpheus.chargedup.commands;

import edu.wpi.first.wpilibj2.command.Command;
import team.frc.morpheus.chargedup.commands.drivebase.AutoBalance;
import team.frc.morpheus.chargedup.commands.drivebase.DriveDistance;
import team.frc.morpheus.chargedup.commands.drivebase.DriveDistanceForward;
import team.frc.morpheus.chargedup.commands.drivebase.TurnInPlace;
import team.frc.morpheus.chargedup.commands.nado.NadoSet;
import team.frc.morpheus.chargedup.commands.nado.NadoSpinSet;
import team.frc.morpheus.chargedup.commands.nado.NadoWristAngle;
import team.frc.morpheus.chargedup.commands.nado.NadoState;
import team.frc.morpheus.chargedup.subsystems.DriveSubsystem;
import team.frc.morpheus.chargedup.subsystems.Nado;
import edu.wpi.first.wpilibj2.command.Commands;
import edu.wpi.first.wpilibj2.command.WaitCommand;

public final class Autos {
  public static Command shootHigh(Nado nado) {
    return Commands.sequence(
      new NadoWristAngle(NadoState.SHOOT_HIGH.wristAngle, NadoState.SHOOT_HIGH.wristTolerance), 
      new NadoSpinSet(NadoState.SHOOT_HIGH.spin, false).raceWith(new WaitCommand(1.0)),
      new NadoSet(NadoState.STOW));
  }

  public static Command shootLow(Nado nado) {
    return Commands.sequence(
      new NadoWristAngle(NadoState.SHOOT_LOW.wristAngle, NadoState.SHOOT_LOW.wristTolerance),
      new NadoSpinSet(NadoState.SHOOT_LOW.spin, false).raceWith(new WaitCommand(1.0)),
      new NadoSet(NadoState.STOW));
  }

  public static Command shootMid(Nado nado) {
    return Commands.sequence(
      new NadoWristAngle(NadoState.SHOOT_MID.wristAngle, NadoState.SHOOT_MID.wristTolerance).raceWith(new WaitCommand(2.0)),
      new NadoSpinSet(NadoState.SHOOT_MID.spin, false).raceWith(new WaitCommand(1.0)),
      new NadoSet(NadoState.STOW)
    );
  }

  public static Command shootHighCross(Nado nado, DriveSubsystem drive) {
    return shootHigh(nado).andThen(new DriveDistance(-1, -4, false));
  }

  public static Command shootHighCrossBalance(Nado nado, DriveSubsystem drive){
    return Commands.sequence(
      shootHigh(nado),
      new DriveDistance(-1, -4.19, false),
      new DriveDistanceForward(1, 2.19, true),
      new AutoBalance()
    );
  }

  public static Command shootMidCross(Nado nado, DriveSubsystem drive) {
    return shootMid(nado).andThen(new DriveDistance(-1, -4, false));
  }

  public static Command shootMidBalance(Nado nado, DriveSubsystem drive) {
    return shootMid(nado).andThen(
      new DriveDistance(-1, -2.19, false),
      new AutoBalance());
  }

  public static Command shootHighBalance(Nado nado, DriveSubsystem drive) {
    return shootHigh(nado).andThen(
      new DriveDistance(-1, -2.19, false),
      new AutoBalance());
  }

  public static Command turn(DriveSubsystem drive) {
    return new TurnInPlace(90, 1);
  }

  private Autos() {
    throw new UnsupportedOperationException("This is a utility class!");
  }
}
